import 'package:auto_route/auto_route.dart';
import 'package:flutter/material.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:remixicon_updated/remixicon_updated.dart';

import 'package:admin_desktop/infrastructure/services/utils.dart';

class HeaderItem extends StatelessWidget {
  final String title;

  const HeaderItem({
    super.key,
    required this.title,
  });

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Text(
          AppHelpers.getTranslation(title),
          style: Style.interMedium(
              size: 22),
        ),
        const Spacer(),
        IconButton(
            onPressed: () {
               context.maybePop();
            },
            icon: const Icon(Remix.close_fill))
      ],
    );
  }
}
